# ARY Tech POS V2

Welcome to the ARY Tech POS V2! This documentation provides an overview of the product, development setup, API usage, and other essential information.

## Table of Contents

1. [Product Overview](#product-overview)
2. [System Architecture](#system-architecture)
3. [Getting Started](#getting-started)
4. [API Documentation](#api-documentation)
5. [Developer Guidelines](#developer-guidelines)
6. [Troubleshooting](#troubleshooting)
7. [Changelog](#changelog)
8. [License](#license)

---

## Product Overview

<img src="./docs/pictures/dashboard.png"  alt="Link"/>

A brief description of the product and its purpose.  
[Link to Product Overview](./docs/product_overview.md)

## System Architecture
An overview of the system's architecture, components, and integrations.  
##### Key features
* Sale <a href="./docs/features/sale.md"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Purchase <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Sale  <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Purchase  <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Gift Voucher <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Godown <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Account <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Barcode Printer <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Trial Balance <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Backup <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Purchase Report <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Group <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Maintainance <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Account Ledger <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Report <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Voucher <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Sales Report <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* General Voucher <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Item <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Party <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* User <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Account Group <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>
* Income Statement <a href="./"><img src="https://static.thenounproject.com/png/194434-200.png" width="20" height="20" alt="Link"/></a>

## Getting Started

How to set up the development environment and run the application locally.  
[Link to Getting Started](./docs/getting_started.md)

## API Documentation

Detailed API documentation with available endpoints, request/response examples, and error handling.  
[Link to API Documentation](./docs/api-documentation.md)

## Developer Guidelines

Coding standards, branch strategies, and best practices for contributing.  
[Link to Developer Guidelines](./docs/developer_guidelines.md)

## Troubleshooting

Common issues and troubleshooting steps for resolving them.  
[Link to Troubleshooting](./docs/troubleshooting.md)

## Changelog

A log of significant changes to the product, including new features and bug fixes.  
[Link to Changelog](./docs/changelog.md)

## License

The project is licensed under the MIT License.  
[Link to License](./license.md)

---

## Additional Notes

For any questions, please refer to the sections above or reach out to the development team.
