<?php

namespace App\Forms;

use App\Classes\Hook;
use App\Models\Procurement;
use App\Models\ProcurementProduct;
use App\Models\Product;
use App\Services\SettingsPage;

class GoodsReceivedNoteForm extends SettingsPage
{
    const IDENTIFIER = 'ns.goods_received_note';

    public $form;
    public $productQuantities;

    public function __construct(
        protected $new_name
    ) {
        $this->new_name = $new_name;

        $totalNewQuantity = ProcurementProduct::with('procurement')
            ->selectRaw('SUM(new_quantity_received) as total_quantity, product_id')
            ->groupBy(['product_id', 'master_product_id'])
            ->get();
        $this->productQuantities = $totalNewQuantity->mapWithKeys(function ($item) {
            return [$item->product_id => $item->total_quantity];
        })->toArray();

        if (!empty(request()->route('identifier'))) {
            $procurement = Procurement::with('products')
                ->with('provider')
                ->find(request()->route('identifier'));
        }

        $this->form = Hook::filter('ns-purchase-order-form', [
            'main' => [
                'name' => 'name',
                'type' => 'text',
                'value' => $this->new_name,
                // 'disabled' => "true",
                'label' => __('Goods Received Note Name'),
                'description' => __('Provide a name that will help to identify the good received note.'),
                'validation' => 'required',
            ],
            'columns' => Hook::filter('ns-procurement-columns', [
                'name' => [
                    'label' => __('Name'),
                    'type' => 'name',
                ],
                'unit' => [
                    'label' => __('Unit'),
                    'type' => 'unit_name',
                ],
                'purchase_price_edit' => [
                    'label' => __('Unit Price'),
                    'type' => 'text',
                ],
                'gross_purchase_price' => [
                    'label' => __('Gross Price'),
                    'type' => 'currency',
                ],
                'tax_value' => [
                    'label' => __('Tax Value'),
                    'type' => 'currency',
                ],
                'tax_name' => [
                    'label' => __('Tax Type'),
                    'type' => 'tax_name',
                ],
                'quantity' => [
                    'label' => __('Quantity'),
                    'type' => 'text',
                ],
                'foc_quantity' => [
                    'label' => __('FoC Quantity'),
                    'type' => 'text',
                ],
                'total_quantity' => [
                    'label' => __('Total Qty.'),
                    'type' => 'text',
                ],
                'discount' => [
                    'label' => __('Discount'),
                    'type' => 'text',
                ],
                'discount_extra' => [
                    'label' => __('Extra Discount'),
                    'type' => 'text',
                ],
                'total_purchase_price' => [
                    'label' => __('Total Price'),
                    'type' => 'currency',
                ],
                'previous_quantity_received' => [
                    'label' => __('Prev Qty. Received'),
                    'type' => 'text',
                ],
                'new_quantity_received' => [
                    'label' => __('New Qty. Received'),
                    'type' => 'text',
                ],
            ]),

            // @TODO - For Future reminder: Product is setting from here;

            //TODO: COntinue from here
            'products' => isset($procurement) ? $procurement->products->map(function ($_product) {
                $product = Product::findOrFail($_product->product_id);
                $product->load('unit_quantities.unit')->get();
                $_product->master_product_id = $_product->id;
                $_product->previous_quantity_received = $this->productQuantities[$_product->product_id] ?? 0; // Use the product_id from $_product
                $_product->new_quantity_received = 0;
                $_product->total_quantity = $_product->quantity + $_product->foc_quantity;
                $_product->procurement = array_merge($_product->toArray(), [
                    '$invalid' => false,
                    'purchase_price_edit' => $_product->purchase_price,
                ]);

                $_product->unit_quantities = $product->unit_quantities;

                return $_product;
            }) : [],
            'tabs' => [
                'general' => include(dirname(__FILE__) . '/goods_received_note/general.php'),
            ],
        ]);
    }
}
