<?php

use App\Crud\ProviderCrud;
use App\Models\Provider;
use App\Services\Helper;
use Carbon\Carbon;

$invoiceDate = ns()->date->now()->format('Y-m-d');
if (isset($procurement) && $procurement->invoice_date) {
    $procurement->invoice_date = Carbon::parse($procurement->invoice_date)->format('Y-m-d');
    $invoiceDate = $procurement->invoice_date;
}

return [
    'label' => __('Procurement'),
    'fields' => [
        // [
        //     'type' => 'text',
        //     'name' => 'invoice_reference',
        //     'value' => $procurement->invoice_reference ?? '',
        //     'label' => __('Invoice Number'),
        //     'description' => __('If the procurement has been issued outside of NexoPOS, please provide a unique reference.'),
        // ],
        // [
        //     'type' => 'date',
        //     'name' => 'delivery_time',
        //     'disabled' => 'true',
        //     'value' => $procurement->delivery_time ?? ns()->date->now()->format('Y-m-d'),
        //     'label' => __('Delivery Time'),
        //     'description' => __('If the procurement has to be delivered at a specific time, define the moment here.'),
        // ],
        [
            'type' => 'date',
            'name' => 'invoice_date',
            'disabled' => 'true',
            'value' => $invoiceDate,
            'label' => __('Invoice Date'),
            'description' => __('If you would like to define a custom invoice date.'),
        ],
        // [
        //     'type' => 'switch',
        //     'name' => 'automatic_approval',
        //     'value' => $procurement->automatic_approval ?? 1,
        //     'options' => Helper::kvToJsOptions([
        //         0 => __('No'),
        //         1 => __('Yes'),
        //     ]),
        //     'label' => __('Automatic Approval'),
        //     'description' => __('Determine if the procurement should be marked automatically as approved once the Delivery Time occurs.'),
        // ],
        [
            'type' => 'hidden',
            'name' => 'delivery_status',
            'value' => $procurement->delivery_status ?? 'pending',
            'validation' => 'required',
            'options' => Helper::kvToJsOptions([
                'pending' => __('Pending'),
                'delivered' => __('Delivered'),
            ]),
            'label' => __('Delivery Status'),
            'description' => __('Determine what is the actual value of the procurement. Once "Delivered" the status can\'t be changed, and the stock will be updated.'),
        ],
        [
            'type' => 'hidden',
            'name' => 'payment_status',
            'value' => $procurement->payment_status ?? 'unpaid',
            'validation' => 'required',
            'options' => Helper::kvToJsOptions([
                'unpaid' => __('Unpaid'),
                'paid' => __('Paid'),
            ]),
            'label' => __('Payment Status'),
            'description' => __('Determine what is the actual payment status of the procurement.'),
        ],
        [
            'type' => 'search-select',
            'name' => 'provider_id',
            'component' => 'nsCrudForm',
            'props' => ProviderCrud::getFormConfig(),
            'value' => $procurement->provider_id ?? '',
            'validation' => 'required',
            'options' => Helper::toJsOptions(Provider::get(), ['id', 'first_name']),
            'label' => __('Provider'),
            'description' => __('Determine what is the actual provider of the current procurement.'),
        ],
        [
            'type' => 'select',
            'name' => 'location',
            'value' => $procurement->location ?? 'store',
            'validation' => 'required',
            'options' => Helper::kvToJsOptions([
                'warehouse' => __('Warehouse'),
                'store' => __('Store'),
            ]),
            'label' => __('Location'),
            'description' => __('Determine what is the location of store.'),
        ],
        [
            'type' => 'select',
            'name' => 'payment_term',
            'value' => $procurement->payment_term ?? '1',
            'validation' => 'required',
            'options' => Helper::kvToJsOptions([
                '1' => __('Payment Term 1'),
                '2' => __('Payment Term 2'),
                '3' => __('Payment Term 3'),
                '4' => __('Payment Term 4'),
                '5' => __('Payment Term 5'),
                '6' => __('Payment Term 5'),

            ]),
            'label' => __('Day(s) of Payment Term'),
            'description' => __('Determine no. of days of payment term of the procurement.'),
        ],
        [
            'type' => 'select',
            'name' => 'payment_mode',
            'value' => $procurement->payment_mode ?? 'cash',
            'validation' => 'required',
            'options' => Helper::kvToJsOptions([
                'cheque' => __('Cheque'),
                'cash' => __('Cash'),
            ]),
            'label' => __('Payment Mode'),
            'description' => __('Determine what is the payment mode of the procurement.'),
        ],
        [
            'type' => 'textarea',
            'name' => 'description',
            'value' => $procurement->description ?? '',
            'label' => __('Remarks'),
            'description' => __('A brief remarks about what this procurement is about.'),
        ],
    ],
];
