<?php

/**
 * AryServicePOS Controller
 *
 * @since  1.0
 **/

namespace App\Http\Controllers\Dashboard;

use App\Crud\BrandCrud;
use App\Http\Controllers\DashboardController;
use App\Models\Brand;
use App\Services\DateService;
use App\Services\Options;
use App\Services\BrandService;
use App\Services\Validation;

class BrandsController extends DashboardController
{
    public function __construct(
        protected BrandService $brandService,
        protected Options $options,
        protected Validation $validation,
        protected DateService $dateService
    ) {
        // ...
    }

    /**
     * Retreive the brand list
     *
     * @return array brands
     */
    public function list()
    {
        return $this->brandService->get();
    }

    public function listBrands()
    {
        return BrandCrud::table();
    }

    public function createBrand()
    {
        return BrandCrud::form();
    }

    public function editBrand(Brand $brand)
    {
        return BrandCrud::form($brand);
    }
    public function deleteBrand($id)
    {
        return $this->brandService->delete($id);
    }

}
