<?php

/**
 * AryServicePOS Controller
 *
 * @since  1.0
 **/

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\DashboardController;
use App\Http\Requests\FormsRequest;
use App\Services\Helper;
use App\Services\ProcurementService;
use App\Services\SettingsPage;
use Exception;
use TorMorten\Eventy\Facades\Events as Hook;

class FormsController extends DashboardController
{
    public function __construct(
        protected ProcurementService $procurementService,
    ) {
    }

    //$id = null added by Taimoor Imran for GRN working - 02:14 PM - 21/Aug/2024
    public function getForm($resource, $id = null)
    {
        /**
         * @var SettingsPage
         */
        $instance = Hook::filter('ns.forms', [], $resource);
        //This conditional block was added by Taimoor Imran for GRN working - 02:14 PM - 21/Aug/2024
        if ($resource == "ns.goods_received_note") {
            $new_grn_name = $this->procurementService->goodsReceivedNoteName($this->procurementService->procurementName($id));
            $instance->form['main']['value'] = $new_grn_name;
            foreach ($instance->form['products']->toArray() as $key => $value) {
                $instance->form['products'][$key]['quantity_received'] = 0;
                // Helper::_pp($value, false);
            }
            // dd($instance->form['products'][0]);
        }
        if (!$instance instanceof SettingsPage) {
            throw new Exception(sprintf(
                '%s is not an instanceof "%s".',
                $resource,
                SettingsPage::class
            ));
        }

        return $instance->getForm();
    }

    public function saveForm(FormsRequest $request, $resource, $identifier = null)
    {
        $instance = Hook::filter('ns.forms', [], $resource, $identifier);

        if (!$instance instanceof SettingsPage) {
            throw new Exception(sprintf(
                '%s is not an instanceof "%s".',
                $resource,
                SettingsPage::class
            ));
        }

        return $instance->saveForm($request);
    }
}
