<?php

namespace App\Listeners;

use App\Events\ProcurementPurchaseOrderAfterUpdateEvent;
use App\Services\ProcurementService;
use App\Services\ProviderService;
use App\Services\TransactionService;

class ProcurementPurchaseOrderAfterUpdateEventListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(
        public ProcurementService $procurementService,
        public ProviderService $providerService,
        public TransactionService $transactionService
    ) {
        //
    }

    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle(ProcurementPurchaseOrderAfterUpdateEvent $event)
    {
        $this->procurementService->refreshPO($event->procurement);
        //These should be the part of GRN:
        // $this->providerService->computeSummary($event->procurement->provider);
        // $this->procurementService->handleProcurement($event->procurement);
        // $this->transactionService->handleProcurementTransaction($event->procurement);
    }
}
