<?php

namespace App\Models;

use App\Traits\NsDependable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

/**
 * @property int            $id
 * @property boolean        $active
 * @property string         $name
 * @property string         $report_name_placeholder
 * @property string         $logo
 * @property string         $description
 * @property string         $website
 * @property string         $email
 * @property string         $phone
 * @property string         $address
 * @property int            $author
 * @property \Carbon\Carbon $created_at
 * @property \Carbon\Carbon $updated_at
 */
class Brand extends NsModel
{
    use HasFactory, NsDependable;

    protected $table = 'nexopos_' . 'brands';

    protected $guarded = [];

    protected $isDependencyFor = [];

    public function scopeActive($query)
    {
        return $query->where('active', true);
    }
}
