<?php

namespace App\Services;

use App\Models\Brand;
use Exception;
use Illuminate\Support\Facades\Auth;

class BrandService
{
    public function get($id = null)
    {
        return $id === null ? Brand::get() : Brand::find($id);
    }

    /**
     * create a brand
     * using the provided informations
     *
     * @param array information to save
     * @return array response
     */
    public function create($data)
    {
        $brand = new Brand;

        foreach ($data as $field => $value) {
            $brand->$field = $value;
        }

        $brand->author = Auth::id();
        $brand->save();

        return [
            'status' => 'success',
            'message' => __('The brand has been created.'),
            'data' => compact('brand'),
        ];
    }

    /**
     * Edit a specific provide using the
     * provided informations
     *
     * @param int brand id
     * @param array data to update
     * @return array response
     */
    public function edit($id, $data)
    {
        $brand = Brand::find($id);

        if ($brand instanceof Brand) {
            foreach ($data as $field => $value) {
                $brand->$field = $value;
            }

            $brand->author = Auth::id();
            $brand->save();

            return [
                'status' => 'success',
                'message' => __('The brand has been updated.'),
                'data' => compact('brand'),
            ];
        }

        throw new Exception(__('Unable to find the brand using the specified id.'));
    }

    /**
     * Delete the brand using the
     * specified id
     *
     * @param int brand id
     * @return array response
     */
    public function delete($id)
    {
        $brand = Brand::findOrFail($id);
        $brand->delete();

        return [
            'status' => 'success',
            'message' => __('The brand has been deleted.'),
        ];
    }
}
