<?php

namespace App\Validators;

use Illuminate\Support\Facades\Validator;

class CustomValidation
{
    public static function register()
    {
        
        Validator::extend('ntn', function ($attribute, $value, $parameters, $validator) {
            if (is_null($value) || $value === '') {
                return true;
            }

            return preg_match('/^\d{8}$/', $value);
        }, __('The N.T.N No. must be a valid 8-digit number (e.g., 12345671).'));

        Validator::extend('contact', function ($attribute, $value, $parameters, $validator) {
            return preg_match('/^((03\d{9})|(0\d{2,3}\d{7}))$/', $value);
        }, __('The contact number is required and must be a valid mobile (03XXXXXXXXX) or landline (0XX XXXXXXX / 0XXX XXXXXXX) number.'));
        
        
        Validator::extend('gst', function ($attribute, $value, $parameters, $validator) {
            if (is_null($value) || $value === '') {
                return true; 
            }
            return preg_match('/^\d{11}$/', $value);
        }, __('The GST number must be exactly 11 digits (e.g., 12345678901).'));
        
        Validator::extend('postalcode', function ($attribute, $value, $parameters, $validator) {
            if (is_null($value) || $value === '') {
                return true; 
            }
            return preg_match('/^\d{5}$/', $value);
        }, __('The postal code must be exactly 5 digits (e.g., 54000).'));
        

        Validator::extend('digits', function ($attribute, $value, $parameters, $validator) {
            if (is_null($value) || $value === '') {
                return true;
            }

            // Extract required length (e.g., `digits:8` → `8`)
            $length = (int) ($parameters[0] ?? 0);

            // Validate exact numeric length
            return is_numeric($value) && strlen((string) $value) === $length;
        }, 'The :attribute must be exactly :size digits.');
    }
}
