## Developer Guidelines

## Documentation

- Use documentation branch to write documentation, and create a PR if you want your code to be merged.

### Code Style

- Follow the Airbnb JavaScript style guide (or any preferred style guide).
- Use ESLint with the configured `.eslintrc.json` file.

### Branching Strategy

- **master**: Contains production-ready code.
- **develop**: Integrates features for the next release.
- **feature/{feature-name}**: Feature-specific branches created from `develop`.

### Commit Messages

- Use the following format for commit messages:
  - **feat**: For new features.
  - **fix**: For bug fixes.
  - **chore**: For maintenance tasks (e.g., updating dependencies).

Example commit message:
