
## Getting Started


### Installation

#### 1️⃣ Create a GitHub folder, navigate into it.
#### 2️⃣ Upload the public key here 
   ```bash
   https://github.com/taimoorimran/ARY-Tech-POS-V2/settings/keys
   ```   
#### 3️⃣ Clone the repository:

   ```bash
   git clone https://github.com/taimoorimran/ARY-Tech-POS-V2.git
   cd ARY-Tech-POS-V2
   ```
#### 4️⃣ Install PHP dependencies:

   ```bash
   composer install
   ```

#### 5️⃣Install NPM dependencies:

   ```bash
   npm install
   ```

#### 6️⃣ Setup configuration:

   ```bash
   cp .env.example .env
   ```

####7️⃣ Setup .htaccess file (Keep this `.htaccess` file in the root of the project):

   ```sh
   cp .htaccess.example .htaccess
   ```
---
## Env File Changes
#### 🔷 **APP_DEBUG**

```bash
# Development
APP_DEBUG=true

# Production (Must always be false)
APP_DEBUG=false
```
📌 **Guidance:**
- Debugging should never be enabled in production to prevent exposing stack traces, environment variables, or sensitive user data.

🚨 Leaving APP_DEBUG=true in production can expose database credentials and application secrets!

---

#### 🔷  **APP_URL**

```bash
# Development (Localhost is fine)
APP_URL=http://127.0.0.1:8000

# Production (Always use HTTPS)
APP_URL=https://pos.arytech.io/
```
📌 **Guidance:**
- Never use HTTP in production—always enforce HTTPS to encrypt data and protect user credentials.
- If hosting on Nginx or Apache, configure SSL certificates (e.g., via Let's Encrypt).

🚨 Make sure your .env file is never exposed via public URLs! Add it to .gitignore to prevent accidental commits.


---

#### 🔷  **Database Configuration**

```bash
# Development
DB_HOST=localhost
DB_DATABASE=ary_tech_pos
DB_USERNAME=root
DB_PASSWORD=

# Production
DB_HOST=ns520721.ip-158-69-118.net
DB_DATABASE=posarytech_staging
DB_USERNAME=posarytech_v2
DB_PASSWORD=.B6C6=Yu.mQj
```
📌 **Guidance:**
- **Development** uses a local database setup.
- **Production** connects to a remote database with stricter access control.

🚨 **Never use production credentials in development!** Keep database access restricted.

---

#### 🔷  **QUEUE_CONNECTION**

```bash
# Development
QUEUE_CONNECTION=database

# Production
QUEUE_CONNECTION=sync
```
📌 **Guidance:**
- **Development** uses the database queue to test queued jobs.
- **Production** may use `sync` for instant execution but should ideally use a **queue service** (Redis, SQS, etc.).

---

#### 🔷  **SESSION_DOMAIN**

```bash
# Development
SESSION_DOMAIN=127.0.0.1

# Production
SESSION_DOMAIN=pos.arytech.io
```
📌 **Guidance:**
- **Development** allows local session storage.
- **Production** restricts sessions to the live domain for security.

---

#### 🔷  **NS_ENV**

```bash
# Development
NS_ENV=dev

# Production
NS_ENV=production
```
📌 **Guidance:**
- Used to differentiate environments within the application.

---

#### 🔷  **Logging & Debugging Tools**

```bash
# Development
TELESCOPE_ENABLED=false

# Production
TELESCOPE_ENABLED=false
```
📌 **Guidance:**
- Laravel Telescope is usually **enabled in development** for debugging but should be **disabled in production** to prevent performance issues.

---

#### 🔷  **Currency & Vendor Settings** _(Only in Production!)_

```bash
# Production Only
NS_CURRENCY_SYMBOL="Rs."
NS_CURRENCY_ISO="PKR"
NS_CURRENCY_POSITION="before"
NS_CURRENCY_PREFERED="iso"
NS_CURRENCY_PRECISION="0"
NS_PROVIDER_CATEGORIES="..."
NS_PROVIDER_TYPES="..."
```

---

#### 8️⃣  Create User 
```bash
# Open Project directory terminal
php artisan ns:setup --store_name=ARYTechPOS --admin_username=admin --admin_email=taimoor.imran@aryservices.com.pk --admin_password=123456 
```

#### 9️⃣ Run Project
```bash
php artisan serve ## For laravel
npm run dev       ## For Development mode 
``` 
