/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
import { Plugin } from '@ckeditor/ckeditor5-core/dist/index.js';
import { Clipboard } from '@ckeditor/ckeditor5-clipboard/dist/index.js';
import { Enter, ShiftEnter } from '@ckeditor/ckeditor5-enter/dist/index.js';
import { SelectAll } from '@ckeditor/ckeditor5-select-all/dist/index.js';
import { Typing } from '@ckeditor/ckeditor5-typing/dist/index.js';
import { Undo } from '@ckeditor/ckeditor5-undo/dist/index.js';
import { AccessibilityHelp } from '@ckeditor/ckeditor5-ui/dist/index.js';

class Essentials extends Plugin {
    /**
     * @inheritDoc
     */ static get requires() {
        return [
            AccessibilityHelp,
            Clipboard,
            Enter,
            SelectAll,
            ShiftEnter,
            Typing,
            Undo
        ];
    }
    /**
     * @inheritDoc
     */ static get pluginName() {
        return 'Essentials';
    }
}

export { Essentials };
//# sourceMappingURL=index.js.map
