"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.collection = void 0;
const hex_1 = __importDefault(require("pure-color/parse/hex"));
const rgb2hsv_1 = __importDefault(require("pure-color/convert/rgb2hsv"));
const rgb2hex_1 = __importDefault(require("pure-color/convert/rgb2hex"));
const hsv2rgb_1 = __importDefault(require("pure-color/convert/hsv2rgb"));
const collection_1 = __importDefault(require("./collection"));
exports.collection = collection_1.default;
/** @deprecated */
class Color {
    constructor(color = '#000') {
        this.alpha = 1;
        this.color = {};
        if (color[0] == '#') {
            this.hex = color;
        }
        else {
            let match = /^(rgb|rgba|hsv)\(([0-9\%\,\.\s]+)\)$/.exec(color.trim());
            if (match) {
                let values = match[2].split(',').map((val) => parseInt(val.trim()));
                switch (match[1]) {
                    case 'rgb':
                        this.rgb = values;
                        break;
                    case 'rgba':
                        this.rgba = values;
                        break;
                    case 'hsv':
                        this.hsv = values;
                        break;
                    default:
                        throw new Error('Unsupported color format: ' + color);
                }
            }
            else {
                throw new Error('Unknown color format: ' + color);
            }
        }
    }
    clone() {
        return new Color('rgb(' + this.rgb.join(',') + ')');
    }
    set rgb(rgb) {
        if (rgb.length != 3) {
            throw new Error('An array with a length of 3 is expected.');
        }
        this.alpha = 1;
        this.color = {
            rgb: rgb,
        };
    }
    get rgb() {
        return (this.color.rgb = this.color.rgb || (this.color.hex ? this.hexToRgb(this.hex) : this.hsvToRgb(this.hsv)));
    }
    set rgba(rgba) {
        if (rgba.length != 4) {
            throw new Error('An array with a length of 3 is expected.');
        }
        this.rgb = [rgba[0], rgba[1], rgba[2]];
        this.alpha = rgba[3];
    }
    get rgba() {
        return [this.rgb[0], this.rgb[1], this.rgb[2], this.alpha];
    }
    set hsv(hsv) {
        if (hsv.length != 3) {
            throw new Error('An array with a length of 3 is expected.');
        }
        this.alpha = 1;
        this.color = {
            hsv: hsv,
        };
    }
    get hsv() {
        // Slice array to return copy
        return (this.color.hsv = this.color.hsv || this.rgbToHsv(this.rgb)).slice(0);
    }
    set hex(hex) {
        this.alpha = 1;
        this.color = {
            hex: hex,
        };
    }
    get hex() {
        // Slice array to return copy
        return (this.color.hex = this.color.hex || this.rgbToHex(this.rgb)).slice(0);
    }
    brighterThan(color, difference) {
        let primaryColorHsv = this.hsv;
        let secondaryColorHsv = color.hsv;
        if (primaryColorHsv[2] >= secondaryColorHsv[2] + difference) {
            return this;
        }
        primaryColorHsv[2] = secondaryColorHsv[2] + difference;
        if (primaryColorHsv[2] > 360) {
            primaryColorHsv[2] = 360;
        }
        this.hsv = primaryColorHsv;
        return this;
    }
    darkerThan(color, difference) {
        let primaryColorHsv = this.hsv;
        let secondaryColorHsv = color.hsv;
        if (primaryColorHsv[2] <= secondaryColorHsv[2] - difference) {
            return this;
        }
        primaryColorHsv[2] = secondaryColorHsv[2] - difference;
        if (primaryColorHsv[2] < 0) {
            primaryColorHsv[2] = 0;
        }
        this.hsv = primaryColorHsv;
        return this;
    }
    brighterOrDarkerThan(color, difference) {
        let primaryColorHsv = this.hsv;
        let secondaryColorHsv = color.hsv;
        if (primaryColorHsv[2] <= secondaryColorHsv[2]) {
            return this.darkerThan(color, difference);
        }
        else {
            return this.brighterThan(color, difference);
        }
    }
    rgbToHex(rgb) {
        return (0, rgb2hex_1.default)(rgb);
    }
    hexToRgb(hex) {
        return (0, hex_1.default)(hex).map((val) => Math.round(val));
    }
    rgbToHsv(rgb) {
        return (0, rgb2hsv_1.default)(rgb).map((val) => Math.round(val));
    }
    hsvToRgb(hsv) {
        return (0, hsv2rgb_1.default)(hsv).map((val) => Math.round(val));
    }
}
exports.default = Color;
Color.collection = collection_1.default;
