"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAvatar = void 0;
const utils = __importStar(require("./utils"));
function createAvatar(style, options = {}) {
    var _a, _b, _c;
    options = utils.options.merge(style, options);
    let prngInstance = utils.prng.create(options.seed);
    let result = style.create({ prng: prngInstance, options });
    if (options.size) {
        result.attributes.width = options.size.toString();
        result.attributes.height = options.size.toString();
    }
    else {
        if (options.width) {
            result.attributes.width = options.width.toString();
        }
        if (options.height) {
            result.attributes.height = options.height.toString();
        }
    }
    if (options.scale !== undefined && options.scale !== 100) {
        result.body = utils.svg.addScale(result, options.scale);
    }
    else if (options.margin) {
        result.body = utils.svg.addMargin(result, options);
    }
    if (options.flip) {
        result.body = utils.svg.addFlip(result);
    }
    if (options.rotate) {
        result.body = utils.svg.addRotate(result, options.rotate);
    }
    if (options.translateX || options.translateY) {
        result.body = utils.svg.addTranslate(result, options.translateX, options.translateY);
    }
    if (options.backgroundColor) {
        let backgroundColor = Array.isArray(options.backgroundColor)
            ? prngInstance.pick(options.backgroundColor)
            : options.backgroundColor;
        result.body = utils.svg.addBackgroundColor(result, backgroundColor);
    }
    result.body = utils.svg.addViewboxMask(result, (_a = options.radius) !== null && _a !== void 0 ? _a : 0);
    const hasMetadata = Boolean((_b = result.head) === null || _b === void 0 ? void 0 : _b.match(/<metadata([^>]*)>/));
    let avatar = utils.svg.removeWhitespace(`
    <svg ${utils.svg.createAttrString(result.attributes)}>
      ${hasMetadata ? '' : utils.svg.getMetadata(style)}
      ${(_c = result.head) !== null && _c !== void 0 ? _c : ''}
      ${result.body}
    </svg>
  `);
    if (options.dataUri) {
        return `data:image/svg+xml;utf8,${encodeURIComponent(avatar)}`;
    }
    /** @deprecated - will be removed with version 5.0 */
    if (options.base64) {
        // @see https://www.base64encoder.io/javascript/
        let encoded = encodeURIComponent(avatar).replace(/%([0-9A-F]{2})/g, function (match, p1) {
            return String.fromCharCode(parseInt(`0x${p1}`));
        });
        // @ts-ignore
        return `data:image/svg+xml;base64,${btoa(encoded)}`;
    }
    return avatar;
}
exports.createAvatar = createAvatar;
