"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const random_1 = __importDefault(require("./random"));
const color_1 = __importDefault(require("./color"));
const parser_1 = __importDefault(require("./parser"));
const core_1 = require("./core");
/**
 * @deprecated use `createAvatar` function instead.
 */
class Avatars {
    /**
     * @param spriteCollection
     */
    constructor(spriteCollection, defaultOptions) {
        this.spriteCollection = spriteCollection;
        this.defaultOptions = defaultOptions;
    }
    /**
     * Creates an avatar
     *
     * @param seed
     */
    create(seed, options) {
        const style = {
            meta: {},
            schema: {},
            create: ({ prng, options: styleOptions }) => {
                let svg = parser_1.default.parse(this.spriteCollection(new random_1.default(prng.seed), styleOptions));
                let head = [];
                let body = [];
                svg.children.forEach((child) => {
                    if (this.isBody(child)) {
                        body.push(child);
                    }
                    else {
                        head.push(child);
                    }
                });
                return {
                    attributes: svg.attributes,
                    head: head.map((v) => parser_1.default.stringify(v)).join(''),
                    body: body.map((v) => parser_1.default.stringify(v)).join(''),
                };
            },
        };
        // @ts-ignore
        return (0, core_1.createAvatar)(style, Object.assign(Object.assign(Object.assign({}, this.defaultOptions), options), { seed }));
    }
    isBody(element) {
        return element.type === 'element' && ['title', 'desc', 'defs', 'metadata'].indexOf(element.name) === -1;
    }
}
exports.default = Avatars;
Avatars.random = random_1.default;
Avatars.color = color_1.default;
Avatars.parser = parser_1.default;
