"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeWhitespace = exports.createAttrString = exports.addViewboxMask = exports.addFlip = exports.addRotate = exports.addTranslate = exports.addScale = exports.addBackgroundColor = exports.addRadius = exports.addMargin = exports.getViewBox = exports.getMetadataLicense = exports.getMetadataWorkAgents = exports.getMetadataWorkContributor = exports.getMetadataWorkLicense = exports.getMetadataWorkSource = exports.getMetadataWorkCreator = exports.getMetadataWorkTitle = exports.getMetadata = exports.getXmlnsAttributes = exports.createGroup = void 0;
const escape = __importStar(require("./escape"));
const ccLicenses = {
    by: {
        permits: ['Reproduction', 'Distribution', 'DerivativeWorks'],
        requires: ['Notice', 'Attribution'],
        prohibits: [],
    },
    'by-sa': {
        permits: ['Reproduction', 'Distribution', 'DerivativeWorks'],
        requires: ['Notice', 'Attribution', 'ShareAlike'],
        prohibits: [],
    },
    'by-nd': {
        permits: ['Reproduction', 'Distribution'],
        requires: ['Notice', 'Attribution'],
        prohibits: [],
    },
    'by-nc': {
        permits: ['Reproduction', 'Distribution', 'DerivativeWorks'],
        requires: ['Notice', 'Attribution'],
        prohibits: ['CommercialUse'],
    },
    'by-nc-sa': {
        permits: ['Reproduction', 'Distribution', 'DerivativeWorks'],
        requires: ['Notice', 'Attribution', 'ShareAlike'],
        prohibits: ['CommercialUse'],
    },
    'by-nc-nd': {
        permits: ['Reproduction', 'Distribution'],
        requires: ['Notice', 'Attribution'],
        prohibits: ['CommercialUse'],
    },
    zero: {
        permits: ['Reproduction', 'Distribution', 'DerivativeWorks'],
        requires: [],
        prohibits: [],
    },
};
function createGroup({ children, x, y }) {
    return `<g transform="translate(${x}, ${y})">${children}</g>`;
}
exports.createGroup = createGroup;
function getXmlnsAttributes() {
    return {
        'xmlns:dc': 'http://purl.org/dc/elements/1.1/',
        'xmlns:cc': 'http://creativecommons.org/ns#',
        'xmlns:rdf': 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
        'xmlns:svg': 'http://www.w3.org/2000/svg',
        xmlns: 'http://www.w3.org/2000/svg',
    };
}
exports.getXmlnsAttributes = getXmlnsAttributes;
function getMetadata(style) {
    return `
    <metadata>
      <rdf:RDF>
        <cc:Work>
          <dc:format>image/svg+xml</dc:format>
          <dc:type rdf:resource="http://purl.org/dc/dcmitype/StillImage" />
          ${getMetadataWorkTitle(style)}
          ${getMetadataWorkCreator(style)}
          ${getMetadataWorkSource(style)}
          ${getMetadataWorkLicense(style)}
          ${getMetadataWorkContributor(style)}
        </cc:Work>
        ${getMetadataLicense(style)}
      </rdf:RDF>
    </metadata>
  `;
}
exports.getMetadata = getMetadata;
function getMetadataWorkTitle(style) {
    if (style.meta.title) {
        return `<dc:title>${style.meta.title}</dc:title>`;
    }
    return '';
}
exports.getMetadataWorkTitle = getMetadataWorkTitle;
function getMetadataWorkCreator(style) {
    if (style.meta.creator) {
        let creators = Array.isArray(style.meta.creator) ? style.meta.creator : [style.meta.creator];
        return `
      <dc:creator>
        ${getMetadataWorkAgents(creators)}
      </dc:creator>
    `;
    }
    return '';
}
exports.getMetadataWorkCreator = getMetadataWorkCreator;
function getMetadataWorkSource(style) {
    if (style.meta.source) {
        return `<dc:source>${style.meta.source}</dc:source>`;
    }
    return '';
}
exports.getMetadataWorkSource = getMetadataWorkSource;
function getMetadataWorkLicense(style) {
    if (style.meta.license) {
        return `<cc:license rdf:resource="${style.meta.license.url}" />`;
    }
    return '';
}
exports.getMetadataWorkLicense = getMetadataWorkLicense;
function getMetadataWorkContributor(style) {
    if (style.meta.contributor) {
        let contributors = Array.isArray(style.meta.contributor) ? style.meta.contributor : [style.meta.contributor];
        return `
      <dc:contributor>
        ${getMetadataWorkAgents(contributors)}
      </dc:contributor>
    `;
    }
    return '';
}
exports.getMetadataWorkContributor = getMetadataWorkContributor;
function getMetadataWorkAgents(agents) {
    return agents.map((agent) => `
      <cc:Agent>
        <dc:title>${agent}</dc:title>
      </cc:Agent>
    `);
}
exports.getMetadataWorkAgents = getMetadataWorkAgents;
function getMetadataLicense(style) {
    var _a, _b;
    let match = (_a = style.meta.license) === null || _a === void 0 ? void 0 : _a.url.match(/^https?:\/\/creativecommons.org\/(?:licenses|publicdomain)\/([a-z\-]+)\/\d.\d\//);
    if (match) {
        let license = ccLicenses[match[1]];
        if (license) {
            let result = ``;
            license.permits.forEach((permits) => {
                result += `<cc:permits rdf:resource="https://creativecommons.org/ns#${permits}" />`;
            });
            license.requires.forEach((requires) => {
                result += `<cc:requires rdf:resource="https://creativecommons.org/ns#${requires}" />`;
            });
            license.prohibits.forEach((prohibits) => {
                result += `<cc:prohibits rdf:resource="https://creativecommons.org/ns#${prohibits}" />`;
            });
            return `
        <cc:License rdf:about="${(_b = style.meta.license) === null || _b === void 0 ? void 0 : _b.url}">
          ${result}
        </cc:License>
      `;
        }
    }
    return '';
}
exports.getMetadataLicense = getMetadataLicense;
function getViewBox(result) {
    let viewBox = result.attributes['viewBox'].split(' ');
    let x = parseInt(viewBox[0]);
    let y = parseInt(viewBox[1]);
    let width = parseInt(viewBox[2]);
    let height = parseInt(viewBox[3]);
    return {
        x,
        y,
        width,
        height,
    };
}
exports.getViewBox = getViewBox;
/**
 * @deprecated use addScale instead
 */
function addMargin(result, options) {
    var _a;
    const margin = typeof options === 'number' ? options : (_a = options.margin) !== null && _a !== void 0 ? _a : 0;
    return addScale(result, 100 - margin * 2);
}
exports.addMargin = addMargin;
/**
 * @deprecated use addViewboxMask instead
 */
function addRadius(result, options) {
    if (undefined === options.radius) {
        return result.body;
    }
    return addViewboxMask(result, options.radius);
}
exports.addRadius = addRadius;
function addBackgroundColor(result, options) {
    var _a;
    let { width, height, x, y } = getViewBox(result);
    let backgroundColor = typeof options === 'string' ? options : (_a = options.backgroundColor) !== null && _a !== void 0 ? _a : 'transparent';
    return `
    <rect fill="${backgroundColor}" width="${width}" height="${height}" x="${x}" y="${y}" />
    ${result.body}
  `;
}
exports.addBackgroundColor = addBackgroundColor;
function addScale(result, scale) {
    let { width, height, x, y } = getViewBox(result);
    let percent = scale ? (scale - 100) / 100 : 0;
    let translateX = (width / 2 + x) * percent * -1;
    let translateY = (height / 2 + y) * percent * -1;
    return `
    <g transform="translate(${translateX} ${translateY}) scale(${scale / 100})">
      ${result.body}
    </g>
  `;
}
exports.addScale = addScale;
function addTranslate(result, x, y) {
    let viewBox = getViewBox(result);
    let translateX = (viewBox.width + viewBox.x * 2) * ((x !== null && x !== void 0 ? x : 0) / 100);
    let translateY = (viewBox.height + viewBox.y * 2) * ((y !== null && y !== void 0 ? y : 0) / 100);
    return `
    <g transform="translate(${translateX} ${translateY})">
      ${result.body}
    </g>
  `;
}
exports.addTranslate = addTranslate;
function addRotate(result, rotate) {
    let { width, height, x, y } = getViewBox(result);
    return `
    <g transform="rotate(${rotate}, ${width / 2 + x}, ${height / 2 + y})">
      ${result.body}
    </g>
  `;
}
exports.addRotate = addRotate;
function addFlip(result) {
    let { width, x } = getViewBox(result);
    return `
    <g transform="scale(-1 1) translate(${width * -1 - x * 2} 0)">
      ${result.body}
    </g>
  `;
}
exports.addFlip = addFlip;
function addViewboxMask(result, radius) {
    let { width, height, x, y } = getViewBox(result);
    let rx = radius ? (width * radius) / 100 : 0;
    let ry = radius ? (height * radius) / 100 : 0;
    return `
    <mask id="avatarsRadiusMask">
      <rect width="${width}" height="${height}" rx="${rx}" ry="${ry}" x="${x}" y="${y}" fill="#fff" />
    </mask>
    <g mask="url(#avatarsRadiusMask)">${result.body}</g>
  `;
}
exports.addViewboxMask = addViewboxMask;
function createAttrString(attributes) {
    attributes = Object.assign(Object.assign({}, getXmlnsAttributes()), attributes);
    return Object.keys(attributes)
        .map((attr) => `${escape.xml(attr)}="${escape.xml(attributes[attr])}"`)
        .join(' ');
}
exports.createAttrString = createAttrString;
function removeWhitespace(svg) {
    return (svg
        // Remove spaces at both ends of the string
        .trim()
        // Remove breaking lines
        .replace(/\n/g, ' ')
        // Remove space between tags
        .replace(/>\s+</g, '><')
        // Reduce whitespace
        .replace(/\s{2,}/g, ' ')
        // Create self closing tags
        .replace(/<([^\/>]+)><\/[^>]+>/gi, '<$1/>')
        // Remove whitespace before tag close
        .replace(/\s(\/?>)/g, '$1'));
}
exports.removeWhitespace = removeWhitespace;
