<?php
use App\Models\Order;
use App\Classes\Hook;
use Illuminate\Support\Facades\View;
// dd($order->toArray());
function calculateDemoSaveGold($total, $type) {
    $gold_fraction = 0;
    $coin_fraction = 0;
    $excessAmount = 0;
    
    if ($total == 25000) {
        $gold_fraction = 0.8;
        $coin_fraction = 0;
    }
    if ($total > 25000) {
        $gold_fraction = 0;
        $coin_fraction = 0.5;
    }

    $result = 0;
    if ($type == "gold") {
        if ($total > 25000) {
            $result = 20000;
        } else {
            $result = $total * $gold_fraction;
        }
    } else if ($type == "coin") {
        if ($total > 25000) {
            $excessAmount = $total - 25000;
            $result = $excessAmount * $coin_fraction;
        } else {
            $result = $total * $coin_fraction;
        }
    }

    return round($result, 2);
}

?>
<div class="receipt-max-w w-full mx-auto receipt-p-0">
    <div class="receipt-bg-white text-black border-b border-t border-dashed border-black">
        <div class="flex flex-col items-center justify-center">
            @if ( empty( ns()->option->get( 'ns_invoice_receipt_logo' ) ) )
                <h3 class="receipt-text-xs font-bold text-black">{{ ns()->option->get( 'ns_store_name' ) }}</h3>
            @else
                <img src="{{ ns()->option->get( 'ns_invoice_receipt_logo' ) }}" style="height:150px" alt="{{ ns()->option->get( 'ns_store_name' ) }}">
                <h3 class="receipt-text-xs font-bold text-black">{{ ns()->option->get( 'ns_store_name' ) }}</h3>
            @endif
        </div>
        <div class="receipt-p-2 border-b border-black">
            <div class="flex flex-wrap -mx-2 receipt-text-xs text-black">
                <div class="px-2 w-1/2">
                    {!! nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_a', $order ) ) !!}
                </div>
                <div class="px-2 w-1/2">
                    {!! nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_b', $order ) ) !!}
                </div>
            </div>
        </div>
        <div class="table w-full">
            <table class="w-full">
                <thead>
                    <tr class="font-semibold receipt-text-xs text-black">
                        <td class="receipt-p-2">{{ __( 'Product' ) }}</td>
                        <td class="receipt-p-2 text-center">{{ __( 'Qty.' ) }}</td>
                        <td class="receipt-p-2 text-right">{{ __( 'Total' ) }}</td>
                    </tr>
                </thead>
                <tbody class="receipt-text-xs border-b border-black text-black">
                    @foreach( Hook::filter( 'ns-receipt-products', $order->combinedProducts ) as $product )
                    <tr>
                        <td class="receipt-p-2">{{ $product->name }}</td>
                        <td class="receipt-p-2 text-center">{{ $product->quantity }}</td>
                        <td class="receipt-p-2 text-right">{{ ns()->currency->define( $product->total_price ) }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tbody>
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Sub Total' ) }}</td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->subtotal ) }}</td>
                    </tr>
                    @if ( $order->discount > 0 )
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">
                            <span>{{ __( 'Discount' ) }}</span>
                            @if ( $order->discount_type === 'percentage' )
                            <span>({{ $order->discount_percentage }}%)</span>
                            @endif
                        </td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->discount ) }}</td>
                    </tr>
                    @endif
                    @if ( $order->total_coupons > 0 )
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Coupons' ) }}</td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->total_coupons ) }}</td>
                    </tr>
                    @endif
                    @if ( ns()->option->get( 'ns_invoice_display_tax_breakdown' ) === 'yes' ) 
                        @foreach( $order->taxes as $tax )
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">
                                <span>{{ $tax->tax_name }} &mdash; {{ $order->tax_type === 'inclusive' ? __( 'Inclusive' ) : __( 'Exclusive' ) }}</span>
                            </td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $tax->tax_value ) }}</td>
                        </tr>
                        @endforeach
                        @if ( $order->products_tax_value > 0 )
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ $order->tax_type === 'inclusive' ? __( 'Inclusive Product Taxes' ) : __( 'Exclusive Product Taxes' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->products_tax_value ) }}</td>
                        </tr>
                        @endif
                    @else                     
                        @if ( $order->tax_value > 0 )
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Taxes' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->tax_value ) }}</td>
                        </tr>
                        @elseif ( $order->products_tax_value > 0 )
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ $order->tax_type === 'inclusive' ? __( 'Inclusive Product Taxes' ) : __( 'Exclusive Product Taxes' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->products_tax_value ) }}</td>
                        </tr>
                        @endif
                    @endif
                    @if ( $order->shipping > 0 )
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Shipping' ) }}</td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->shipping ) }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Total' ) }}</td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->total ) }}</td>
                    </tr>
                    @foreach( $order->payments as $payment )
                    <tr>
                        <td class="receipt-p-2 receipt-text-xs font-semibold text-black" colspan="2">{{ $paymentTypes[ $payment[ 'identifier' ] ] ?? __( 'Unknown Payment' ) }}</td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $payment[ 'value' ] ) }}</td>
                    </tr>
                    @endforeach
                    <tr>
                        <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Paid' ) }}</td>
                        <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->tendered ) }}</td>
                    </tr>
                    @if ( in_array( $order->payment_status, [ 'refunded', 'partially_refunded' ]) )
                        @foreach( $order->refund as $refund )
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Refunded' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( - $refund->total ) }}</td>
                        </tr>
                        @endforeach
                    @endif
                    @switch( $order->payment_status )
                        @case( Order::PAYMENT_PAID )
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Change' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( $order->change ) }}</td>
                        </tr>
                        @break
                        @case( Order::PAYMENT_PARTIALLY )
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Due' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ ns()->currency->define( abs( $order->change ) ) }}</td>
                        </tr>
                        @break
                    @endswitch
                    <tr class="border-t border-dashed border-black">
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Save Gold' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ calculateDemoSaveGold($order->total, 'gold') }} mg</td>
                        </tr>
                        <tr>
                            <td colspan="2" class="receipt-p-2 receipt-text-xs font-semibold text-black">{{ __( 'Cold Coin' ) }}</td>
                            <td class="receipt-p-2 receipt-text-xs text-right text-black">{{ calculateDemoSaveGold($order->total, 'coin') }}</td>
                        </tr>
                </tbody>
            </table>
            @if( $order->note_visibility === 'visible' )
            <div class="receipt-pt-6 receipt-pb-4 text-center receipt-text-xs text-black">
                <strong>{{ __( 'Note: ' ) }}</strong> {{ $order->note }}
            </div>
            @endif
            <div class="receipt-pt-6 receipt-pb-4 text-center receipt-text-xs text-black">
                {{ ns()->option->get( 'ns_invoice_receipt_footer' ) }}
            </div>
        </div>
    </div>
</div>
@includeWhen( request()->query( 'autoprint' ) === 'true', '/pages/dashboard/orders/templates/_autoprint' )

<style>
@media print {
    .receipt-max-w {
        max-width: 210px !important; /* Adjust this to fit your thermal paper width */
    }
    .receipt-p-0 {
        padding: 0 !important;
    }
    .receipt-bg-white {
        background-color: white !important;
    }
    .receipt-text-xs {
        font-size: 10px !important; /* Adjust as necessary for your print layout */
    }
    .receipt-p-2 {
        padding: 2px !important; /* Adjust as necessary for your print layout */
    }
    .receipt-pt-6 {
        padding-top: 6px !important; /* Adjust as necessary for your print layout */
    }
    .receipt-pb-4 {
        padding-bottom: 4px !important; /* Adjust as necessary for your print layout */
    }
    /* Set overall text color to black */
    body {
        color: black !important;
    }
}
</style>
