<?php
use App\Classes\Hook;
use App\Models\PaymentType;
use App\Services\OrdersService;

$ordersService  =   app()->make( OrdersService::class );
?>
<div class="w-full h-full">
    <div class="w-full md:w-1/2 lg:w-1/3 shadow-lg bg-white p-2 mx-auto">
        <div class="flex items-center justify-center">
            <h3 class="text-3xl font-bold"><?php echo e(ns()->option->get( 'ns_store_name' )); ?></h3>
        </div>
        <div class="p-2 border-b border-gray-700">
            <div class="flex flex-wrap -mx-2 text-sm">
                <div class="px-2 w-1/2">
                    <?php echo nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_a', $refund->order ) ); ?>

                </div>
                <div class="px-2 w-1/2">
                    <?php echo nl2br( $ordersService->orderTemplateMapping( 'ns_invoice_receipt_column_b', $refund->order ) ); ?>

                </div>
            </div>
        </div>
        <div class="table w-full">
            <table class="w-full">
                <thead>
                    <tr class="font-semibold">
                        <td colspan="2" class="p-2 border-b border-gray-800"><?php echo e(__( 'Product' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-right"><?php echo e(__( 'Total' )); ?></td>
                    </tr>
                </thead>
                <tbody class="text-sm">
                    <?php
                    $products   =   Hook::filter( 'ns-refund-receipt-products', $refund->refunded_products );
                    ?>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-700">
                            <span class=""><?php echo e($product->product->name); ?> (x<?php echo e($product->quantity); ?>)</span>
                            <br>
                            <span class="text-xs text-gray-600"><?php echo e($product->unit->name); ?></span> &mdash; <span class="text-xs text-gray-600"><?php echo e(__( 'Condition:' )); ?> <?php echo e($ordersService->getRefundedOrderProductLabel( $product->condition )); ?>

                        </td>
                        <td class="p-2 border-b border-gray-800 text-right"><?php echo e(Currency::raw( $product->total_price - $product->tax_value )); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tbody>
                    <?php if( $refund->tax_value > 0 ): ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Sub Total' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( 
                            $products->map( fn( $product ) => Currency::raw( $product->total_price - $product->tax_value ) )->sum()
                        )); ?></td>
                    </tr>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Tax' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $refund->tax_value )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Total' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $refund->total )); ?></td>
                    </tr>
                    <?php if( $refund->shipping > 0 ): ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e(__( 'Shipping' )); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $refund->shipping )); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php
                    $paymentType    =   PaymentType::where( 'identifier', $refund->payment_method )->first();
                    $paymentName    =   $paymentType instanceof PaymentType ? $paymentType->label : __( 'Unknown Payment' );
                    ?>
                    <tr>
                        <td colspan="2" class="p-2 border-b border-gray-800 text-sm font-semibold"><?php echo e($paymentName); ?></td>
                        <td class="p-2 border-b border-gray-800 text-sm text-right"><?php echo e(ns()->currency->define( $refund->total )); ?></td>
                    </tr>
                </tbody>
            </table>
            <div class="pt-6 pb-4 text-center text-gray-800 text-sm">
                <?php echo e(ns()->option->get( 'ns_invoice_receipt_footer' )); ?>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->renderWhen( request()->query( 'autoprint' ) === 'true', '/pages/dashboard/orders/templates/_autoprint' , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?><?php /**PATH /home/gposarytech/public_html/resources/views/pages/dashboard/orders/templates/_refund_receipt.blade.php ENDPATH**/ ?>