<?php
namespace RawMaterial\Inc;

use Exception;
use Tendoo_Module;
use RawMaterial\Classes\Material;
use RawMaterial\Exceptions\NotFoundRecipeException;
use User;

class Filters extends Tendoo_Module
{
    public function __construct()
    {
        parent::__construct();
        $this->setup    =   new Setup;
    }

    public function admin_menus( $menus )
    {
        if ( ( ! multistore_enabled() || ( multistore_enabled() && is_multistore() ) ) && ( User::in_group( 'master' ) || User::in_group( 'store.manager' ) ) ) {
            $menus  =   array_insert_after( 'arrivages', $menus, 'raw-material', [
                [
                    'title'         =>  __( 'Raw Material', 'raw-material' ),
                    'href'          =>  '#',
                    'disable'       =>  true,
                    'icon'          =>  'fa fa-pie-chart',
                    // 'permission'    =>  'nexo.manage.settings',
                ], [
                    'title'         =>  __( 'Units Groups', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'unitGroups' ]),
                ], [
                    'title'         =>  __( 'Units Entities', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'units' ]),
                ], [
                    'title'         =>  __( 'Materials', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'materials' ]),
                ], [
                    'title'         =>  __( 'Material Supplies', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'supplies' ]),
                ], [
                    'title'         =>  __( 'Material Adjustments', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'materialAdjustments' ]),
                ], [
                    'title'         =>  __( 'Gastro Recipes', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'recipes' ]),
                ], [
                    'title'         =>  __( 'Materials Report', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'reports', 'materials' ]),
                ], [
                    'title'         =>  __( 'Materials Stock Report', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'reports', 'materialstock' ]),
                ],[
                    'title'         =>  __( 'Recipe Report', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'reports', 'recipes' ]),
                ], [
                    'title'         =>  __( 'Settings', 'raw-material' ),
                    'href'          =>  site_url([ 'dashboard', store_slug(), 'raw-material', 'settings' ]),
                ] 
            ]);
        }   
        return $menus;
    }

    public function add_recipe_column( $columns )
    {
        array_splice( $columns, 4, 0, [ 'REF_RECIPE', 'OVERRIDE_STOCK' ]);
        return $columns;
    }

    /**
     * Reset the module
     * while it's required
     * @param string state
     * @return string
     */
    public function reset( $state )
    {
        $this->load->model( 'Nexo_Stores' );

        $stores         =   $this->Nexo_Stores->get();

        array_unshift( $stores, [
            'ID'        =>  0
        ]);

        foreach( $stores as $store ) {
            $store_prefix       =   $store[ 'ID' ] == 0 ? '' : 'store_' . $store[ 'ID' ] . '_';
            $this->setup->uninstall( $this->db->dbprefix . $store_prefix );
            $this->setup->install( $this->db->dbprefix . $store_prefix );
        }

        return 'reset-completed';
    }

    public function product_crud( $crud )
    {
        $crud->display_as( 'REF_RECIPE', __( 'Assigned Recipe', 'raw-material' ) );
        $crud->set_relation( 'REF_RECIPE', store_prefix() . 'gastro_materials_recipes', 'NAME' );

        $crud->display_as( 'OVERRIDE_STOCK', __( 'Override Stock', 'raw-material' ) );
        $crud->field_description( 'OVERRIDE_STOCK', __( 'The Raw Material stock will be used instead of the default one.', 'raw-material' ) );
        $crud->field_type( 'OVERRIDE_STOCK', 'dropdown', [
            0   =>  __( 'No', 'raw-material' ),
            1   =>  __( 'Yes', 'raw-material' )
        ]);

        return $crud;
    }

    /**
     * we do deduct while tha order is 
     * paid. 
     * @param array order details
     * @param array post_data
     */
    public function pre_check_stock( $order_details, $post_data )
    {
        if ( $this->events->apply_filters_ref_array( 'raw_material_stock_precheck_override', [ false, $order_details, $post_data ] ) === false ) {

            $material       =   new Material;
            $results        =   [];
            $flyStock       =   [];
    
            foreach( $post_data[ 'ITEMS' ] as $item ) {
                if ( ! empty( $item[ 'REF_RECIPE' ] ) ) {
                    $result     =   $material->canConsumeRecipe( $item[ 'REF_RECIPE' ], ( float ) $item[ 'QTE_ADDED' ], $flyStock );
                    $flyStock   =   $result[ 'data' ][ 'flyStock' ];
                    $results[]     =   [
                        'depletion'     =>  $result,
                        'item'          =>  $item
                    ];
                }
            }
    
            $hasExhaustedMaterial   =   collect( $results )->filter( function( $result ) {
                return $result[ 'depletion' ][ 'status' ] === 'failed' && $result[ 'depletion' ][ 'class' ] !== NotFoundRecipeException::class;
            });
                    
            if ( $hasExhaustedMaterial->count() > 0 ) {
                header( 'HTTP/1.0 403 Forbidden' );
                echo json_encode([
                    'status'    =>  'failed',
                    'message'   =>  __( 'Unable to proceed, as one of the ingredient is not enough.', 'raw-material' ),
                    'data'      =>  $results,
                    'by'        =>  'raw-material'
                ]);
                die;
            }

            $material->autoConvertIfPossible( $results );
        }

        return $order_details;
    }

    public function release_materials( $order_details, $post, $order_id )
    {
        $material   =   new Material;
        
        $this->load->module_model( 'nexo', 'Nexo_Orders_Model', 'order_model' );
        $this->load->module_model( 'nexo', 'NexoItems', 'item_model' );

        $items      =   $this->order_model->getOrderProducts( $order_id );

        foreach( $items as $item ) {
            $product   =   $this->item_model->getUsingBarcode( $item[ 'REF_PRODUCT_CODEBAR' ] ) ;

            if ( $this->events->apply_filters( 'raw_material_release_materials', true, $order_details, $post, $order_id, $item ) ) {
                $material->restoreMaterialFromRecipeSilently( 
                    $product[ 'REF_RECIPE' ],
                    $item[ 'ID' ],
                    $item[ 'QUANTITE' ]
                );
            }
        }

        return $order_details;
    }
}