<div id="material-supplies">
    <div class="form-group">
        <label for=""><?php echo __( 'Procurement Title', 'raw-material' );?></label>
        <input v-on:change="resetProcurementSelection()" v-model="procurement.title" type="text" class="form-control">
        <small class="help-description"><?php echo __( 'Fill this to create a new procurement.', 'raw-material' );?></small>
    </div>
    <div class="form-group">
        <label for=""><?php echo __( 'Assign to a procurement', 'raw-material' );?></label>
        <select v-on:change="triggerChange()" v-model="procurement.ref_id" data-live-search="true" type="text" id="created-procurement" class="form-control">
            <option v-for="supply of supplies" :value="supply.ID">{{ supply.NAME }}</option>
        </select>
        <small class="help-description"><?php echo __( 'Choose a procurement to assign the current items to it.', 'raw-material' );?></small>
    </div>
    <div class="box">
        <div class="box-body no-padding">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th><?php echo __( 'Material', 'raw-material' );?></th>
                    <th><?php echo __( 'UOM', 'raw-material' );?></th>
                    <th width="150"><?php echo __( 'Unit Price', 'raw-material' );?></th>
                    <th width="150"><?php echo __( 'Quantity', 'raw-material' );?></th>
                    <th><?php echo __( 'Total', 'raw-material' );?></th>
                    <th width="50"></th>
                </tr>
            </thead>
            <tbody>
                <tr> 
                    <tr v-for="( entry, index ) of procurement.entries">
                        <td>{{ entry.name }}</td>
                        <td>
                            <select class="form-control input-sm" v-model="entry.uom" id="">
                                <option v-for="option of entry.uom_choices" :value="option.ID">{{ option.NAME }}</option>
                            </select>
                        </td>
                        <td>
                            <input v-model="entry.purchase_price" type="text" class="form-control input-sm">
                        </td>
                        <td>
                            <input v-model="entry.quantity" type="text" class="form-control input-sm">
                        </td>
                        <td>
                            {{ entry.total = entry.quantity * entry.purchase_price | moneyFormat }}
                        </td>
                        <td><button @click="deleteEntry( index )" class="btn btn-sm btn-danger"><i class="fa fa-remove"></i></button></td>
                    </tr>
                    <td colspan="6">
                        <div class="input-group" style="width: 100%;">
                            <select data-live-search="true" v-model="selectedMaterial" id="add-material" type="text" placeholder="" class="form-control">
                                <option :value="material" v-for="material of materials">{{ material.NAME }}</option>
                            </select>
                            <span @click="makeProcurement()" class="input-group-btn">
                                <button class="btn btn-default" type="button"><?php echo __( 'Save the procurement', 'raw-material' );?></button>
                            </span>
                        </div>
                    </td>
                </tr>
            </tbody>
            </table>
        </div>
    </div>
</div>
<link rel="stylesheet" href="<?php echo module_url( 'raw-material' ) . 'css/bootstrap-select.min.css';?>">
<script src="<?php echo module_url( 'raw-material' ) . 'js/bootstrap-select.min.js';?>"></script>
<script>
"use strict";
const MaterialSuppliesData  =   {
    textDomain: {
        confirmAction: `<?php echo __( 'Would you like to proceed ?', 'raw-material' );?>`,
        emptyEntries: `<?php echo __( 'Unable to proceed, make sure to select at least one material.', 'raw-material' );?>`,
        confirmProcurement: `<?php echo __( 'The procurement has some warning. Would you like to proceed anyaway ?', 'raw-material' );?>`,
        priceNotSet: `<?php echo __( 'The item <strong>%s</strong> doesn\'t have purchase price defined.', 'raw-material' );?>`,
        notUnitSelected: `<?php echo __( 'The item <strong>%s</strong> doesn\'t have a unit of measure selected.', 'raw-material' );?>`,
        noEnoughQuantity: `<?php echo __( 'The item <strong>%s</strong> doesn\'t have a quantity defined.', 'raw-material' );?>`,
        confirmTheProcurement: `<?php echo __( 'The procurement will be saved. Since this operation will affect the database, you need to confirm your action.', 'raw-material' );?>`,
        deleteThisEntry: `<?php echo __( 'Would you like to delete this material entry ? This operation cannot be reverted.', 'raw-material' );?>`,
        proceedWithProcurement: `<?php echo __( 'Would you like to proceed with the procurement ?.', 'raw-material' );?>`,
    },
    materials :    <?php echo json_encode( $materials );?>,
    supplies: <?php echo json_encode( $supplies );?>,
    units : <?php echo json_encode( $units );?>,
    url: {
        submitProcurement: '<?php echo site_url([ 'api', 'raw-material', 'procurement', store_get_param( '?' ) ]);?>'
    }
}
</script>
<script>
"use strict";
const MaterialSuppliesVue   =   new Vue({
    el: '#material-supplies',
    data: {
        ...MaterialSuppliesData,
        selectedMaterial: null,
        procurement : {
            entries :   [],
            title: '',
            ref_id: ''
        }
    },
    mounted() {
        this.mountSearchChoosen();
    },
    methods: {
        reset() {
            this.procurement    =   {
                entries :   [],
                title: '',
                ref_id: ''
            };
        },
        resetProcurementSelection() {
            this.procurement.ref_id     =   '';
            setTimeout( () => {
                $( '#created-procurement' ).selectpicker( 'destroy' );
                $( '#created-procurement' ).selectpicker();
            }, 200 );
        },
        triggerChange() {
            this.procurement.title  =   '';
        },
        deleteEntry( index ) {
            swal({ 
                title: this.textDomain.confirmAction,
                text: this.textDomain.deleteThisEntry,
                showCancelButton: true,
            }).then( result => {
                if ( result.value ) {
                    this.procurement.entries.splice( index, 1 );
                }
            });
        },
        mountSearchChoosen() {
            $( '#add-material' ).selectpicker();
            $( '#created-procurement' ).selectpicker();
            $( '#add-material' ).on( 'changed.bs.select', () => this.addSelectedMaterial() );
        },
        makeProcurement() {
            if ( this.procurement.entries.length === 0 ) {
                return NexoAPI.Toast()( this.textDomain.emptyEntries );
            }

            const errorsBag     =   [];
            const infoBag       =   [];

            this.procurement.entries.forEach( entry => {
                if ( parseFloat( entry.quantity ) === 0 ) {
                    errorsBag.push({
                        item: entry,
                        message: this.textDomain.noEnoughQuantity.replace( '%s', entry.name )
                    });
                }

                if ( parseFloat( entry.purchase_price ) === 0 ) {
                    infoBag.push({
                        item: entry,
                        message: this.textDomain.priceNotSet.replace( '%s', entry.name )
                    });
                }

                if ( entry.uom === '' ) {
                    errorsBag.push({
                        item: entry,
                        message: this.textDomain.notUnitSelected.replace( '%s', entry.name )
                    });
                }
            });

            $( '.notices' ).remove();
            $( '#material-supplies' ).append( '<div class="notices"></div>' );
            if ( infoBag.length > 0 ) {
                infoBag.forEach( info => {
                    $( '.notices' ).append(
                        `
                        <div class="alert alert-info">
                            ${info.message}
                        </div>
                        `
                    )
                })
            }

            if ( errorsBag.length > 0 ) {
                errorsBag.forEach( info => {
                    $( '.notices' ).append(
                        `
                        <div class="alert alert-danger">
                            ${info.message}
                        </div>
                        `
                    )
                })
            }

            if ( errorsBag.length === 0 ) {
                swal({
                    title: this.textDomain.confirmAction,
                    text: infoBag.length > 0 ? this.textDomain.confirmProcurement : this.textDomain.proceedWithProcurement,
                    showCancelButton: true
                }).then( result => {
                    if ( result.value ) {
                        this.proceedToProcurement();
                    }
                });
            }
        },
        proceedToProcurement() {
            HttpRequest.post( this.url.submitProcurement, this.procurement ).then( result => {
                NexoAPI.Toast()( result.data.message );
                this.reset();
            })
        },
        addSelectedMaterial() {

            const choices   =   this.units.filter( unit => unit.REF_UNIT_GROUP === this.selectedMaterial.REF_UNIT_GROUP );
            const material  =   {
                material        :   this.selectedMaterial.ID,
                name            :   this.selectedMaterial.NAME,
                uom             :  '',
                quantity        :   0,
                purchase_price  :   0,
                uom_choices     :   choices,
                total           :   0
            };

            this.selectedMaterial   =   null;

            this.procurement.entries.push( material );
        }
    }
})
</script>