<?php
namespace RawMaterial;

use Tendoo_Module;
use RawMaterial\Inc\Actions;
use RawMaterial\Inc\Filters;

class Module extends Tendoo_Module
{
    public function __construct()
    {
        parent::__construct();

        $this->actions  =   new Actions;
        $this->filters  =   new Filters;

        $this->events->add_action( 'do_enable_module', [ $this->actions, 'enable_module' ]);
        $this->events->add_action( 'tendoo_reset_raw-material', [ $this->filters, 'reset' ]);
        $this->events->add_action( 'load_dashboard', [ $this->actions, 'register_recipe_field' ]);
        $this->events->add_action( 'load_dashboard', [ $this->actions, 'check_tables' ]);
        $this->events->add_action( 'load_pos_footer', [ $this->actions, 'load_pos_footer' ]);
        $this->events->add_action( 'nexo_empty_shop', [ $this->actions, 'nexo_empty_shop' ]);
        $this->events->add_action( 'delete_nexo_store', [ $this->actions, 'delete_store' ], 10, 3 );
        $this->events->add_action( 'nexo_after_install_tables', [ $this->actions, 'install_tables' ], 10, 3 );
        $this->events->add_action( 'load_dashboard', [ $this->actions, 'load_dashboard' ]);
        $this->events->add_action( 'tendoo_settings_final_config', [ $this->actions, 'enable_material' ], 20 );

        $this->events->add_filter( 'admin_menus', [ $this->filters, 'admin_menus' ], 30 );
        $this->events->add_filter( 'product_columns', [ $this->filters, 'add_recipe_column' ]);
        $this->events->add_filter( 'load_product_crud', [ $this->filters, 'product_crud' ]);
        $this->events->add_filter( 'post_order_details', [ $this->filters, 'pre_check_stock' ], 10, 2 );
        $this->events->add_action( 'gastro_change_food_status', [ $this->actions, 'preconsume_material' ], 10, 4 );
        $this->events->add_action( 'gastro_before_change_food_status', [ $this->actions, 'check_stock' ], 10, 4 );
    }
}

new Module;