<?php
namespace RawMaterial\Inc;

use Tendoo_Module;
use Modules;

class Setup extends Tendoo_Module
{
    public function __construct()
    {
        parent::__construct();
    }

    public function install( $table_prefix )
    {
        /**
         * ->full_prefix
         * ->store_prefix
         */
        $short_prefix   =   str_replace( $this->db->dbprefix, '', $table_prefix );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_units` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `NAME` varchar(200) NOT NULL,
            `UNIT_NAME` varchar(200) NOT NULL,
            `DESCRIPTION` text NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `TYPE` varchar(200) NOT NULL,
            `BASE_UNIT` int(1) NOT NULL,
            `UNIT_VALUE` float(11) NOT NULL,
            `REF_UNIT_GROUP` int(11) NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_units_groups` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `NAME` varchar(200) NOT NULL,
            `DESCRIPTION` text NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `NAME` varchar(200) NOT NULL,
            `SKU` varchar(200) NOT NULL,
            `DESCRIPTION` text NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            `REF_UNIT_GROUP` int(11),
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_units_stock` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `QUANTITY` float(11) NOT NULL,
            `REF_UNIT` int(11) NOT NULL,
            `REF_MATERIAL` int(11) NOT NULL,
            `INCOMING_CONVERSION` int(1) NOT NULL,
            `OUTGOING_CONVERSION` int(1) NOT NULL,
            `DESCRIPTION` text NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );
        
        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_recipes_summary` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `REF_RECIPE` int(11) NOT NULL,
            `REF_ORDER_PRODUCT` int(11) NOT NULL,
            `REF_PRODUCT` int(11) NOT NULL,
            `QUANTITY` float(11) NOT NULL,
            `STATUS` varchar(11) NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_usage` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `REF_PRODUCT` int(11) NOT NULL,
            `REF_RECIPE` int(11) NOT NULL,
            `REF_UNIT` int(11) NOT NULL,
            `QUANTITY` float(11) NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_usage_summary` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `REF_PRODUCT` int(11) NOT NULL,
            `REF_ORDER_PRODUCT` int(11) NOT NULL,
            `REF_RECIPE` int(11) NOT NULL,
            `REF_UNIT` int(11) NOT NULL,
            `REF_MATERIAL` int(11) NOT NULL,
            `STATUS` varchar(11) NOT NULL,
            `QUANTITY` float(11) NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_recipes` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `NAME` varchar(200) NOT NULL,
            `DESCRIPTION` text NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_recipes_items` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `REF_RECIPE` int(11) NOT NULL,
            `REF_MATERIAL` int(11) NOT NULL,
            `QUANTITY` float(11) NOT NULL,
            `REF_UNIT` int(11) NOT NULL,
            `DESCRIPTION` text NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_supplies` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `NAME` varchar(200) NOT NULL,
            `TOTAL_ITEMS` int(11) NOT NULL, 
            `TOTAL_COST` float(11) NOT NULL,
            `DESCRIPTION` text NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query( 'CREATE TABLE IF NOT EXISTS `' . $table_prefix . 'gastro_materials_supplies_items` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `REF_SUPPLY` int(11) NOT NULL,
            `REF_UNIT` int(11) NOT NULL,
            `REF_MATERIAL` int(11) NOT NULL,
            `PURCHASE_PRICE` float(11) NOT NULL,
            `QUANTITY` float(11) NOT NULL, 
            `TOTAL_PRICE` float(11) NOT NULL,
            `AUTHOR` int(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MOD` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $this->db->query('CREATE TABLE IF NOT EXISTS `'. $table_prefix .'gastro_materials_adjustments` (
            `ID` int(11) NOT NULL AUTO_INCREMENT,
            `AUTHOR` int(11) NOT NULL,
            `ACTION` varchar(200) NOT NULL,
            `REF_MATERIAL` int(11) NOT NULL,
            `REF_UNIT` int(11) NOT NULL,
            `VALUE` float(11) NOT NULL,
            `DATE_CREATION` datetime NOT NULL,
            `DATE_MODIFICATION` datetime NOT NULL,
            PRIMARY KEY (`ID`)
        )' );

        $columns            =   $this->db->list_fields( $short_prefix . 'nexo_articles' );
        if ( ! in_array( 'REF_RECIPE', $columns ) ) {
            $this->db->query( 'ALTER TABLE `' . $table_prefix . 'nexo_articles` 
                ADD `REF_RECIPE` int(11) NOT NULL AFTER `AUTHOR`;' );
        }

        $columns            =   $this->db->list_fields( $short_prefix . 'nexo_articles' );
        if ( ! in_array( 'OVERRIDE_STOCK', $columns ) ) {
            $this->db->query( 'ALTER TABLE `' . $table_prefix . 'nexo_articles` 
                ADD `OVERRIDE_STOCK` int(1) NOT NULL AFTER `AUTHOR`;' );
        }

        Modules::enable( 'raw-material' );
    }

    public function uninstall( $table_prefix )
    {
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_units`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_units_groups`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_units_stock`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_recipes`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_recipes_items`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_recipes_summary`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_usage`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_usage_summary`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_supplies`;');
        $this->db->query('DROP TABLE IF EXISTS `' . $table_prefix . 'gastro_materials_supplies_items`;');
        
        $short_prefix       =   str_replace( $this->db->dbprefix, '', $table_prefix );
        $columns            =   $this->db->list_fields( $short_prefix . 'nexo_articles' );
        if ( in_array( 'REF_RECIPE', $columns ) ) {
            $this->db->query( 'ALTER TABLE `' . $table_prefix . 'nexo_articles` 
                DROP COLUMN `REF_RECIPE`' );
        }

        $columns            =   $this->db->list_fields( $short_prefix . 'nexo_articles' );
        if ( in_array( 'OVERRIDE_STOCK', $columns ) ) {
            $this->db->query( 'ALTER TABLE `' . $table_prefix . 'nexo_articles` 
                DROP COLUMN `OVERRIDE_STOCK`' );
        }
    }
}