<div class="box" id="adjustment-app">
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputEmail1"><?php echo __( 'Material', 'raw-material' );?></label>
            <select @change="loadUnits( form.material_id )" class="form-control" v-model="form.material_id">
                <option :value="material.ID" v-for="material of materials">{{ material.NAME }}</option>
            </select>
            <p class="help-block"><?php echo __( 'Select the material to proceed the adjustment', 'raw-material' );?></p>
        </div>
        <div class="form-group">
            <label for="exampleInputEmail1"><?php echo __( 'Units', 'raw-material' );?></label>
            <select class="form-control" v-model="form.unit_id">
                <option :value="unit.ID" v-for="unit of units">{{ unit.NAME }} ({{ unit.stock.QUANTITY }})</option>
            </select>
            <p class="help-block"><?php echo __( 'Select the unit from the material you want to adjust.', 'raw-material' );?></p>
        </div>
        <div class="form-group">
            <label for="exampleInputEmail1"><?php echo __( 'Action', 'raw-material' );?></label>
            <select class="form-control" v-model="form.action_type">
                <option :value="action.value" v-for="action of actions">{{ action.label }}</option>
            </select>
            <p class="help-block"><?php echo __( 'Define the action that will be performed.', 'raw-material' );?></p>
        </div>
        <div class="form-group">
            <label for="exampleInputEmail1"><?php echo __( 'Value', 'raw-material' );?></label>
            <input v-model="form.value" class="form-control">
            <p class="help-block"><?php echo __( 'Define the value that will either be deducted or added.', 'raw-material' );?></p>
        </div>
        <div class="form-group">
            <label for="exampleInputEmail1"><?php echo __( 'Details', 'raw-material' );?></label>
            <textarea v-model="form.description" class="form-control">
            </textarea>
            <p class="help-block"><?php echo __( 'Provide context to the current operation.', 'raw-material' );?></p>
        </div>
    </div>
    <div class="box-footer">
        <button @click="proceedDeduction()" class="btn btn-primary"><?php echo __( 'Submit' );?></button>
    </div>
</div>
<script>
"use strict";
new Vue({
    el: '#adjustment-app',
    data: {
        materials: <?php echo json_encode( $materials );?>,
        units: [],
        form: {
            material_id: '',
            description: '',
            value: '',
            action_type: '',
            unit_id: '',
        },
        action_type: '',
        actions: <?php echo json_encode( $actions );?>,
        material_id: '',
        unit_id: '',
    },
    methods: {
        loadUnits( id ) {
            HttpRequest.get( '<?php echo site_url([ 'api', 'raw-material', 'materials', '#', 'units' ]);?>'.replace( '#', id ) )
                .then( result => {
                    this.unit_id    =   '';
                    this.units      =   result.data.units;
                })
        },
        proceedDeduction() {

            for( let index in this.form ) {
                if ( ! [ 'description' ].includes( index ) && this.form[ index ].length === 0 ) {
                    NexoAPI.Toast()( '<?php echo __( 'Please the form is not valid' );?>' );
                    return;
                }
            }

            swal({
                title: `<?php echo __( 'Would you like to confirm ?', 'raw-material' );?>`,
                showCancelButton: true,
                html: `<?php echo __( 'The current adjustment is about to be submitted. This action cannot be deleted or canceled. Please confirm.', 'raw-material' );?>`
            }).then( result => {
                if ( result.value ) {
                    HttpRequest.post( `<?php echo site_url([ 'api', 'raw-material', 'materials', 'adjustment' ]);?>`, {
                        ...this.form
                    })
                        .then( result => {
                            NexoAPI.Toast()( result.data.message );
                            this.form   =   {
                                material_id: '',
                                description: '',
                                value: '',
                                action_type: '',
                                unit_id: '',
                            };
                        })
                }
            })
        }
    },
    watch: {
    },
    mounted() {
    }
})
</script>