<div id="recipe-report"> 
    <form class="form-inline hidden-print">
        <date-picker label="<?php echo __( 'Début', 'nexo_premium' );?>" date-format="YYYY-MM-DD" @changed="changeStartDate( $event )" :value="startDate" v-once></date-picker>
        <date-picker label="<?php echo __( 'Fin', 'nexo_premium' );?>" date-format="YYYY-MM-DD" @changed="changeEndDate( $event )" :value="endDate" v-once></date-picker>
        <input 
            type="button" 
            class="btn btn-primary" 
            @click="getReport()"
            value="<?php _e('Afficher les résultats', 'nexo_premium');?>" />
        <div class="input-group">
            <span class="input-group-btn">
                <button class="btn btn-default" print-item=".report-wrapper"
                    type="button"><?php _e('Imprimer', 'nexo_premium');?></button>
            </span>
        </div>
    </form>
    <br>
    <div class="row">
        <div class="col-md-8">
            <div class="box">
                <div class="box-body no-padding">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <td><?php echo __( 'Recipe', 'raw-material' );?></td>
                                <td><?php echo __( 'Product', 'raw-material' );?></td>
                                <td class="text-right"><?php echo __( 'Quantity', 'raw-material' );?></td>
                                <td class="text-right"><?php echo __( 'Date', 'raw-material' );?></td>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-if="entries.length === 0">
                                <td colspan="4"><?php echo __( 'There is nothing to display...', 'raw-material' );?></td>
                            </tr>
                            <tr v-for="entry of entries">
                                <td>{{ getRecipe( entry.REF_RECIPE ).NAME }}</td>
                                <td>{{ getProduct( entry.REF_PRODUCT ).DESIGN }}</td>
                                <td class="text-right">{{ entry.QUANTITY }}</td>
                                <td class="text-right">{{ entry.DATE_CREATION }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
"use strict";
const RecipeReportData  =   {
    url : {
        getRecipeReport: `<?php echo site_url([ 'api', 'raw-material', 'reports', 'recipes', store_get_param( '?' ) ]);?>`
    },
    products : <?php echo json_encode( $products );?>,
    recipes : <?php echo json_encode( $recipes );?>,
}
</script>
<script>
"use strict";
$( document ).ready( function() {
    var datepickerComponent = Vue.component( 'date-picker', {
        //v-el:select
        template: `
        <div class="input-group date" v-el:inputgroup>
            <span class="input-group-addon">{{ label }}</span>
            <input type="text" class="form-control" v-model="value">
            <span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
        </div>
        `,
        props: [ 'value', 'dateFormat', 'label' ],
        data: function() {
            return {};
        },
        mounted() {
            this.label      =   this.label || 'Date';
            $(this.$el).datetimepicker({
                format: this.dateFormat || 'YYYY-MM-DD'
            });
            $( this.$el ).on( 'dp.change', ( e ) => {
                this.startDate  =   $( e.currentTarget ).find( 'input' ).val();
                this.$emit( 'changed', this.startDate );
            })
        },
        beforeDestroy: function() {
            $(this.$el).datepicker('hide').datepicker('destroy');
        }
    });
    const RecipeReport     =   new Vue({
        el: '#recipe-report',
        data: {
            rawRecipes: [],
            ...RecipeReportData,
            startDate: '',
            endDate: ''
        },
        computed: {
            entries() {
                return this.rawRecipes;
            }
        },
        mounted() {
            this.getReport();
        },
        methods: {
            getProduct( id ) {
                const result    =   this.products.filter( product => product.ID === id );
                return result.length > 0 ? result[0] : {};
            },
            getRecipe( id ) {
                const result    =   this.recipes.filter( recipe => recipe.ID === id );
                return result.length > 0 ? result[0] : {};
            },
            changeStartDate( event ) {
                this.startDate  =   event;
            },
            changeEndDate( event ) {
                this.endDate    =   event;
            },
            getReport() {
                HttpRequest.post( this.url.getRecipeReport, {
                    startDate:  this.startDate,
                    endDate: this.endDate
                }).then( result => {
                    this.rawRecipes     =   result.data;
                })
            }
        }
    });
});
</script>