const ReceipeApp    =   new Vue({
    el: '#recipe-builder',
    mounted() {
        if ( this.rawRecipe !== null ) {
            this.buildRawMaterial();
        }
    },
    data: {
        recipe: {
            ingredients: [],
            name: '',
            description: '',
            deleted: []
        },
        ...RecipeBuilderData
    },
    methods: {
        buildRawMaterial() {
            this.recipe.name            =   this.rawRecipe.NAME;
            this.recipe.description     =   this.rawRecipe.DESCRIPTION;
            this.recipe.ingredients     =   this.rawRecipe.ingredients.map( ingredient => {
                return {
                    uom : ingredient.REF_UNIT,
                    material: ingredient.REF_MATERIAL,
                    quantity: parseFloat( ingredient.QUANTITY ),
                    id: ingredient.ID
                }
            });
        },

        addEmptyIngredient() {
            this.recipe.ingredients.push({
                material: '',
                uom: '',
                quantity: 1
            });
        },
        
        reset() {
            this.recipe     =   {
                ingredients: [],
                name: '',
                description: ''
            }
        },

        getUOM( ingredient ) {
            if ( ingredient.material !== '' ) {
                const material  =   this.materials.filter( mat => mat.ID === ingredient.material );
                if ( material.length > 0 ) {
                    const group     =   this.unitsGroup.filter( group => group.ID === material[0].REF_UNIT_GROUP );
                    if ( group.length > 0 ) {
                        return group[0].units;
                    }
                }
            }
            return [];
        },

        removeIngredientUsing( index ) {
            swal({
                title: this.textDomain.wouldYouLIkeToProceed,
                text: this.textDomain.thisIngredientWillBeDeleted,
                showCancelButton: true
            }).then( result => {
                if ( result.value ) {
                    const deleted   =   this.recipe.ingredients[ index ];


                    if ( deleted.id ) {
                        this.recipe.deleted.push( deleted.id );
                    }

                    this.recipe.ingredients.splice( index, 1 );
                    console.log( this.recipe );
                }
            })
        },

        duplicate( ingredient ) {
            const finalObject   =   Object.assign( {}, ingredient );

            if ( finalObject.id ) {
                delete finalObject.id;
            }

            this.recipe.ingredients.push( finalObject );
        },

        saveRecipe() {
            if ( this.recipe.ingredients.length === 0 ) {
                return swal({
                    title: this.textDomain.unableToProceed,
                    text: this.textDomain.atLeastOneIngredientIsRequired,
                    type: 'error'
                });
            }

            if ( this.recipe.name === '' || this.recipe.name.length < 3 ) {
                return swal({
                    title: this.textDomain.unableToProceed,
                    text: this.textDomain.provideAValidName,
                    type: 'error'
                });
            }

            let isValid     =   true;

            this.recipe.ingredients.forEach( (ingredient, index ) => {
                for( key in ingredient ) {
                    if ( ingredient[ key ] === '' || parseFloat( ingredient[ key ] ) === 0 ) {
                        $( '.ingredient-' + key + '-' + index ).addClass( 'has-error' );
                        isValid     =   false;
                    } else {
                        $( '.ingredient-' + key + '-' + index ).removeClass( 'has-error' );
                    }
                }
            });

            if ( ! isValid ) {
                return swal({
                    title: this.textDomain.unableToProceed,
                    text: this.textDomain.makeSureTohaveFilledTheIngredient,
                    type: 'error'
                }); 
            }

            swal({
                title: this.textDomain.confirmYourAction,
                text: this.textDomain.recipeWillBeSaved,
                showCancelButton: true
            }).then( result => {
                if ( result.value ) {
                    if ( this.rawRecipe === null ) {
                        HttpRequest.post( this.url.saveRecipe, this.recipe )
                            .then( result => {
                                NexoAPI.Toast()( result.data.message  );
                                this.reset();
                            })
                            .catch( error => {
                                console.log( error );
                            })
                    } else {
                        HttpRequest.put( this.url.updateRecipe, this.recipe )
                            .then( result => {
                                NexoAPI.Toast()( result.data.message  );
                                if ( this.rawMaterial === null ) {
                                    this.reset();
                                } else {
                                    this.rawMaterial    =   result.data.data.rawMaterial;
                                }
                            })
                            .catch( error => {
                                console.log( error );
                            })
                    }
                }
            })

        }
    },
})