<div id="recipe-builder">
    <div class="row">
        <div class="col-md-12">
            <div class="recipe-title">
                <div class="form-group">
                    <label><?php echo __( 'Recipe Name', 'raw-material' );?></label>
                    <div class="input-group">
                        <div class="input-group-btn">
                            <button @click="addEmptyIngredient()" type="button" class="btn btn-success">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                        <!-- /btn-group -->
                        <input v-model="recipe.name" type="text" class="form-control">
                        <div class="input-group-btn">
                            <button @click="saveRecipe()" type="button" class="btn btn-primary">
                                <?php echo __( 'Save', 'raw-material' );?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="box collapsed-box">
                    <div class="box-header">
                        <h4 class="box-title"><?php echo __( 'Description', 'raw-material' );?></h4>
                        <div class="pull-right box-tools">
                            <button type="button" class="btn btn-default btn-sm" data-widget="collapse" data-toggle="tooltip" title="" data-original-title="Collapse">
                            <i class="fa fa-plus"></i></button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="form-group">
                            <label for=""><?php echo __( 'Recipe Description', 'raw-material' );?></label>
                            <textarea v-model="recipe.description" name="" id="" cols="30" rows="10" class="form-control"></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="recipe-body">
                <p class="bg-info" v-if="recipe.ingredients.length === 0" style="padding: 10px 20px;"><?php echo __( 'Looks like there is no ingredient.', 'raw-material' );?> <a @click="addEmptyIngredient()" href="javascript:void(0)">Add one ?</a></p>
                <div class="row">
                    <div class="col-md-4" v-for="( ingredient, index ) of recipe.ingredients">
                        <div class="box">
                            <div class="box-header with-border">
                                <h3 class="box-title"><?php echo __( 'Ingredient', 'raw-material' );?></h3>
                                <div class="box-tools pull-right">
                                    <button @click="duplicate( ingredient )" type="button" class="btn btn-box-tool"><i class="fa fa-copy"></i>
                                    </button>
                                    <button @click="removeIngredientUsing( index )" type="button" class="btn btn-box-tool"><i class="fa fa-times"></i></button>
                                </div>
                            </div>
                            <div class="box-body">
                                <div class="form-group" :class="'ingredient-material-' + index">
                                    <label><?php echo __( 'Material', 'raw-material' );?></label>
                                    <select type="text" class="form-control" v-model="ingredient.material">
                                        <option v-for="material of materials" :value="material.ID">{{ material.NAME }}</option>
                                    </select>
                                    <span id="helpBlock" class="help-block text-sm"><?php echo __( 'Which material is required for this recipe.', 'raw-material' );?></span>
                                </div>
                                <div class="form-group" :class="'ingredient-uom-' + index">
                                    <label><?php echo __( 'UOM', 'raw-material' );?></label>
                                    <select type="text" class="form-control" v-model="ingredient.uom">
                                        <option v-for="unit of getUOM( ingredient )" :value="unit.ID">{{ unit.NAME }}</option>
                                    </select>
                                    <span id="helpBlock" class="help-block text-sm"><?php echo __( 'Choose the unit from the material unit group that is required.', 'raw-material' );?></span>
                                </div>
                                <div class="form-group" :class="'ingredient-quantity-' + index">
                                    <label><?php echo __( 'Quantity', 'raw-material' );?></label>
                                    <input v-model="ingredient.quantity" type="text" class="form-control">
                                    <span id="helpBlock" class="help-block text-sm"><?php echo __( 'Define how many of the specified unit, is used for this recipe.', 'raw-material' );?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo module_url( 'nexo' ) . '/js/chosen.directive.vue.js';?>"></script>
<script>
"use strict";
const RecipeBuilderData     =   {
    materials   :   <?php echo json_encode( $materials );?>,
    unitsGroup  :   <?php echo json_encode( $unitsGroups );?>,
    rawRecipe      :   <?php echo json_encode( @$recipe );?>,
    url: {
        saveRecipe: '<?php echo site_url([ 'api', 'raw-material', 'recipe', 'save', store_get_param()]);?>',
        updateRecipe: '<?php echo site_url([ 'api', 'raw-material', 'recipe', 'update', @$recipe[ 'ID' ], store_get_param()]);?>',
    },
    textDomain: {
        wouldYouLIkeToProceed : `<?php echo __( 'Would You Proceed', 'raw-material' );?>`,
        confirmYourAction: `<?php echo __( 'Would You Confirm ?', 'raw-material' );?>`,
        recipeWillBeSaved: `<?php echo __( 'The recipe will be saved. Would you like to continue ?', 'raw-material' );?>`,
        thisIngredientWillBeDeleted : `<?php echo __( 'The ingredient will be deleted. Confirm your action.', 'raw-material' );?>`,
        unableToProceed: `<?php echo __( 'Unable to proceed', 'raw-material' );?>`,
        provideAValidName: `<?php echo __( 'Please provide a valid name to the recipe with at least 3 letters.', 'raw-material' );?>`,
        atLeastOneIngredientIsRequired: `<?php echo __( 'Your recipe should have at least one ingredient.', 'raw-material' );?>`,
        makeSureTohaveFilledTheIngredient: `<?php echo __( 'Make sure you have correctly filled the ingredients.', 'raw-material' );?>`,
    }
}
</script>
<script src="<?php echo module_url( 'raw-material' ) . '/js/recipe.vue.js';?>"></script>