<div class="row">
    <div class="col-md-12">
        <div class="box">
            <div class="box-body no-padding">
                <div class="table-responsive stock-report">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo __( 'Material', 'raw-material' );?></th>
                                <th><?php echo __( 'Unit', 'raw-material' );?></th>
                                <th><?php echo __( 'Quantity', 'raw-material' );?></th>
                                <th><?php echo __( 'Base Unit', 'raw-material' );?></th>
                                <th><?php echo __( 'Base Quantity', 'raw-material' );?></th>
                                <th><?php echo __( 'Group', 'raw-material' );?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach( $stocks as $stock ):?>
                            <?php
                            $unit       =   $units[ $stock[ 'REF_UNIT' ] ] ?? [];
                            $group      =   ! empty( $groups ) ? ( $groups[ ( $unit[ 'REF_UNIT_GROUP' ] ?? [] ) ] ?? [] ) : [];
                            $baseUnit   =   collect( $units )->filter( function( $unit ) use ( $group ) {
                                return $unit[ 'REF_UNIT_GROUP' ] === ($group[ 'ID' ] ?? 0 ) && $unit[ 'BASE_UNIT' ] === '1';
                            })->first();
                            if ( $group !== false ): 
                            ?>
                            <tr>
                                <td><?php echo $materials[ $stock[ 'REF_MATERIAL' ] ][ 'NAME' ];?></td>
                                <td><?php echo $units[ $stock[ 'REF_UNIT' ] ][ 'NAME' ];?></td>
                                <td><?php echo $stock[ 'QUANTITY' ];?></td>
                                <td><?php echo $baseUnit[ 'NAME' ] ?? __( 'Unknown' );?></td>
                                <td><?php echo $units[ $baseUnit[ 'ID' ] ][ 'QUANTITY' ] ?? 0;?></td>
                                <td><?php echo $group[ 'NAME' ];?></td>
                            </tr>
                            <?php endif;?>
                            <?php endforeach;?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="box-footer">
                <button print-item=".stock-report" class="btn btn-primary"><?php echo __( 'Print Report', 'raw-material' );?></button>
            </div>
        </div>
    </div>
</div>