<div id="materials-report"> 
    <form class="form-inline hidden-print">
        <date-picker label="<?php echo __( 'Début', 'nexo_premium' );?>" date-format="YYYY-MM-DD" @changed="changeStartDate( $event )" :value="startDate" v-once></date-picker>
        <date-picker label="<?php echo __( 'Fin', 'nexo_premium' );?>" date-format="YYYY-MM-DD" @changed="changeEndDate( $event )" :value="endDate" v-once></date-picker>
        <input 
            type="button" 
            class="btn btn-primary" 
            @click="getReport()"
            value="<?php _e('Afficher les résultats', 'nexo_premium');?>" />
        <div class="input-group">
            <span class="input-group-btn">
                <button class="btn btn-default" print-item=".report-wrapper"
                    type="button"><?php _e('Imprimer', 'nexo_premium');?></button>
            </span>
        </div>
    </form>
    <br>
    <div class="box">
        <div class="box-body no-padding">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <td><?php echo __( 'Material', 'raw-material' );?></td>
                        <td><?php echo __( 'Unit', 'raw-material' );?></td>
                        <td><?php echo __( 'Quantity', 'raw-material' );?></td>
                        <td><?php echo __( 'Status', 'raw-material' );?></td>
                        <td><?php echo __( 'Date', 'raw-material' );?></td>
                        <td><?php echo __( 'Details', 'raw-material' );?></td>
                    </tr>
                </thead>
                <tbody>
                    <tr v-if="entries.length === 0">
                        <td colspan="6" class="text-center"><?php echo __( 'There is nothing to display.', 'raw-material' );?></td>
                    </tr>
                    <tr v-for="entry of entries">
                        <td>{{ entry.material ? entry.material.NAME : textDomain.undefined }}</td>
                        <td>{{ entry.unit ? entry.unit.NAME : textDomain.undefined }}</td>
                        <td>{{ entry.QUANTITY }}</td>
                        <td>{{ entry.human_status }}</td>
                        <td>{{ entry.DATE_CREATION }}</td>
                        <td>
                            
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script>
"use strict";
const MaterialReportData    =   {
    url: {
        getReport: `<?php echo site_url([ 'api', 'raw-material', 'reports', 'materials', store_get_param( '?' ) ]);?>`
    },
    textDomain: {
        undefined   : `<?php echo __( 'Undefined', 'raw-material' );?>`,
    },
    statuses: <?php echo json_encode([
        'convert-out'   =>  __( 'Outgoing Conversion', 'raw-material' ),
        'convert-in'    =>  __( 'Incoming Conversion', 'raw-material' ),
        'consumption'   =>  __( 'Consumption', 'raw-material' ),
        'deletion'      =>  __( 'Deletion', 'raw-material' ),
        'procurement'   =>  __( 'Procurement', 'raw-material' ),
    ]);?>,
    units: <?php echo json_encode( ( array ) @$units );?>,
    materials: <?php echo json_encode( ( array ) @$materials );?>,
}
</script>
<script>
"use strict";
$( document ).ready( function() {
    var datepickerComponent = Vue.component( 'date-picker', {
        //v-el:select
        template: `
        <div class="input-group date" v-el:inputgroup>
            <span class="input-group-addon">{{ label }}</span>
            <input type="text" class="form-control" v-model="value">
            <span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
        </div>
        `,
        props: [ 'value', 'dateFormat', 'label' ],
        data: function() {
            return {};
        },
        mounted() {
            this.label      =   this.label || 'Date';
            $(this.$el).datetimepicker({
                format: this.dateFormat || 'YYYY-MM-DD'
            });
            $( this.$el ).on( 'dp.change', ( e ) => {
                this.startDate  =   $( e.currentTarget ).find( 'input' ).val();
                this.$emit( 'changed', this.startDate );
            })
        },
        beforeDestroy: function() {
            $(this.$el).datepicker('hide').datepicker('destroy');
        }
    });
    const MaterialReportVue     =   new Vue({
        el: '#materials-report',
        data: {
            startDate: '',
            endDate: '',
            rawEntries: [],
            ...MaterialReportData
        },
        mounted() {
            this.getReport();
        },
        methods: {
            changeStartDate( e ) {
                this.startDate  =   e;
            },
            changeEndDate(e) {
                this.endDate    =   e;
            },
            getReport() {
                HttpRequest.post( this.url.getReport, {
                    startDate: this.startDate,
                    endDate: this.endDate
                }).then( result => {
                    this.rawEntries     =   result.data;
                })
            },
            getUnit( id ) {
                const unit  =   this.units.filter( _unit => _unit.ID === id );
                if ( unit.length > 0 ) {
                    return unit[0];
                }
                return false;
            },
            getMaterial( id ) {
                const material  =   this.materials.filter( _material => _material.ID === id );

                if ( material.length > 0 ) {
                    return material[0];
                }
                return false;
            },
            getStatus( status ) {
                return this.statuses[ status ] || this.textDomain.undefined;
            }
        },
        computed: {
            entries() {
                return this.rawEntries.map( entry => {
                    entry.unit  =   this.getUnit( entry.REF_UNIT );
                    entry.material  =   this.getMaterial( entry.REF_MATERIAL );
                    entry.human_status = this.getStatus( entry.STATUS );
                    return entry;
                });
            }
        }
    });
});
</script>