<div id="reset-wrapper">
    <?php echo tendoo_info( __( 'Enable defaults, by creating default units groups and units entities', 'raw-material' ) );?>
    <div class="checkbox">
        <label>
        <input v-model="clearAll" type="checkbox"> <?php echo __( 'Clear Everything', 'raw-material' );?>
        </label>
    </div>
    <button @click="resetMaterials()" class="btn btn-primary"><?php echo __( 'Reset Defaults', 'raw-material' );?></button>
    <button @click="defineUnitQuantities()" class="btn btn-primary"><?php echo __( 'Define Unit Quantities', 'raw-material' );?></button>
</div>
<script>
"use strict";
const rawMaterialSettings   =   {
    textDomain: {
        confirmYourAction : `<?php echo __( 'Confirm Your Action', 'raw-material' );?>`,
        willApplyDefaultMaterials : `<?php echo __( 'The default values for the raw material module will be created.', 'raw-material' );?>`,
        willDefineUnitQuantities : `<?php echo __( 'The default unit quantities will be set for all the materials.', 'raw-material' );?>`,
    },
    url : {
        createDefaults: '<?php echo site_url([ 'api', 'raw-material', 'defaults', store_get_param( '?' ) ]);?>',
        defineUnitQuantities: '<?php echo site_url([ 'api', 'raw-material', 'unit-stock', 'auto', store_get_param( '?' ) ]);?>',
    }
}
</script>
<script>
"use strict";
const ResetApp  =   new Vue({
    el: '#reset-wrapper',
    data: {
        ...rawMaterialSettings,
        clearAll: false
    },
    mounted() {
    },
    methods: {
        resetMaterials() {
            swal({
                title: this.textDomain.confirmYourAction,
                text: this.textDomain.willApplyDefaultMaterials,
                showCancelButton: true
            }).then( result => {
                if ( result.value ) {
                    this.doResetMaterial();
                }
            })
        },

        defineUnitQuantities() {
            swal({
                title: this.textDomain.confirmYourAction,
                text: this.textDomain.willDefineUnitQuantities,
                showCancelButton: true
            }).then( result => {
                if ( result.value ) {
                    this.doDefineUnitQuantities();
                }
            })
        },

        doResetMaterial() {
            HttpRequest.post( this.url.createDefaults, {
                clearAll: this.clearAll
            })
                .then( result => {
                    NexoAPI.Toast()( result.data.message );
                    this.clearAll   =   false;
                })
        },

        doDefineUnitQuantities() {
            HttpRequest.get( this.url.defineUnitQuantities )
                .then( result => {
                    NexoAPI.Toast()( result.data.message );
                    this.clearAll   =   false;
                })
        }
    }
})
</script>